import re
import shlex
from subprocess import Popen, PIPE, STDOUT
import sys

def collect_command_output(cmd, stderr=STDOUT):
    args = shlex.split(cmd)
    return Popen(args, stdout=PIPE, stderr=stderr).communicate()[0]

def collect_ping_average(host):
    cmd = "C:/Windows/System32/ping.exe {host} -n 4".format(host=host)
    res = str(collect_command_output(cmd))
    pattern = "Average = ([.0-9]+)ms"
    match = re.search(pattern, res, re.MULTILINE)
    if match:
        print(match.group(1))
    else:
        print("-1")

if len(sys.argv) < 2:
    print("run-ping.py hostname")
    sys.exit(1)
else:
    collect_ping_average(sys.argv[1])
    sys.exit(0)
